#|Arxiu: linies.lisp
  Contingut: programa per a calcular linies de corrent estacionaries. Arxiu principal.
  Ultima actualitzacio: 6/11/06
  Autor: Felip Alaez Nadal. |#



(in-package :linies)


(defparameter *Ux* nil "Component x de la velocitat.")
(defparameter *Uy* nil "Component y de la velocitat.")
(defparameter *multiplicador* 2. "Tamany del pas usat en la interpolació.")
(defparameter *tolerancia* 1. "Multiplicador per a saver quan un punt és singular.")
(defparameter *separacio_camps_x* 2. "Multiplicador per a separar més els punts en la x a la graella.")
(defparameter *separacio_camps_y* 2. "Multiplicador per a separar més els punts en la y a la graella.")


(defun string2number ( str )
  "Converteix un string a un nombre."
  (with-input-from-string ( streamet str )
    (read streamet)))

(defun string2symbol ( str )
  "Converteix un string en un symbol."
  (with-input-from-string (streamet str )
    (read streamet)))

(defun string2integer ( str )
  (truncate (string2number str)))

(defun string_es_buit ( str )
  "Torna t si l'string es buit."
  (let
      ( ( retornable t)
       (l (length  str))
	)
    (do ((i 0 (incf i)))
	((= i l) retornable)
      (if (equal (elt str i) #\   )  nil (setq retornable nil)))
    ))



(defun asigna_funcions ( string_x string_y )
  "Assigna les funcions components de la velocitat. Error si alguna d'elles es un string buit o no es una formula correcta."
  (print 'assignant)
  (if (or (string_es_buit string_x ) (string_es_buit string_y )) (progn
								   (setq *Ux* nil)
								   (setq *Uy* nil)
								   (error "Formula buida. Per favor, introdueix una formula valida."))) 
  (setq *Ux* (create_function_from_expression string_x ))
  
  (setq *Uy* (create_function_from_expression string_y))
  )


(defun sobre ( )
  "Mostra el dialeg sobre..."
  (let*
      ((top (make-instance 'toplevel :title "A sobre de..."))
       (txt (make-instance 'label :master top :text " Linies de corrent 003.
Programa per a calcular linies de corrent en fluids estacionaris.
Copyright 2006 per Felip Alaez Nadal <feana@alumni.uv.es>.
Aquest programa es software lliure. Podeu usar-lo en termes de la llicencia GPL.")))
    (pack txt)
    ))


(defun manual ()
  "Mostra el dialeg de manual."
  (let*
      ((top (make-instance 'toplevel :title "Manual"))
       (txt (make-instance 'scrolled-text :master top )))
    (setf (text txt ) 
	  "+ Manual d'us del programa, versio 003. +


Aquest programa realitza una representacio de linies de corrent estacionaries al pla x,y. Fa açò mitjançant interpolacions successives de rectes a partir de:
   - el punt on es clica
   - el pendent de la recta en eixe punt, calculat a partir de l'equació de les línies de corrent, és a dir: m = Ux / Uy.
El programa està limitat a veure projeccions al pla x-y de línies de corrent que només depenen de les variables x i y, i a més el fluxe ha de ser estacionari.

Per tal d'usar el programa, s'introdueixen les components del camp de velocitats als requadres habilitats per a això, i es clica en el botó 'usar funcions'. Una vegada fet això, només queda clicar en un punt del sistema de coordenades per veure la línia de corrent què passa per eixe punt.

El programa té vàries opcions, per a elegir l'interval dels eixos x i y en què es vol treballar i per a canviar el tamany de les divisions ( 1 unitat per defecte ). Aquests valors han de ser nombres enters. En cas d'introduïr nombres decimals, el programa els converteix automàticament a enters.

Es pot comprovar el funcionament del programa amb alguns casos pràctics, sense singularitats:
- Ux = 1 , Uy = 2. En aquest cas trivial, la integració de la línia de corrent dona y = y0 + 2*( x - x0). Si per exemple, cliquem al punt (1,1), es pot veure com apareix aquesta recta.

- Ux = 0.5 , Uy = x. En aquest cas, apareix y = y0 + x^2.

- Ux = 1 , Uy = cos ( x ). En aquest cas, la línia de corrent és y = y0 + sin(x). Si cliquem al punt (0,0), veiem com apareix la funció sinus.


Introducció de fòrmules matemàtiques:

El programa usa un parser de fòrmules matemàtiques per a interpretar quines funcions se li estan passant. Aquest parser, però, és limitat. Açò vol dir què cal seguir certes normes en introduïr les fòrmules:

- Separar nombres i operadors amb un espai. Per exemple, 1 + 2 és una expressió vàlida, però 1+2, 1+ 2 i 1 +2 no.
- Posar parèntesis al voltant dels arguments de funcions que prenen només un argument. Per exemple, sin(x), cos(x).
- Davant el dubte, un espai de més no fa cap mal.
- Fins al moment, CREC (no ho he provat exhaustivament) què posar parèntesis de forma redundant no afecta al funcionament del parser.

Seguiu aquestes normes i tot anirà bé. En cas contrari, rebreu un error. Potser no en el moment de clicar al botó d'usar funcions, però sí quan cliqueu al sistema de referència.

Funcions reconegudes pel parser:

+ : suma
- : resta
* : multiplicacio
/ : divisio
** : potencia
exp : exponencial
sin : sinus
cos : cosinus
tan : tangent
sinh : sinus hiperbòlic
cosh : cosinus hiperbòlic
tanh : tangent hiperbòlica.

Exportant captures de pantalla:

El programa és capaç d'exportar el contingut de la pantalla a un gràfic en format postscript. Per tal de fer açò, simplement elegiu l'opció de guardar al menú arxiu. Per tal de veure gràfics en postscript, en Windows necessitareu el programa GhostView. En Linux no deuríeu tindre cap problema ;-)

Representació del camp de velocitats:

Anant al menú opcions -> dibuixar camp de velocitats, s'obté una representació del camp. Es pot modificar la quantitat de punts mostrats al menú configurar.

"

	  )
    (pack txt)
    ))

(defun bugs_coneguts ()
  "Mostra el dialeg de bugs coneguts."
  (let*
      ((top (make-instance 'toplevel :title "Bugs coneguts"))
       (txt (make-instance 'text :master top )))
    (setf (text txt ) 
	  "  *Si la línia de corrent conté punts singulars, la interpolació no serà vàlida prop d'ells. Per exemple, si l'equació de la línia de corrent fora tg(x), en x = pi/2 hi ha un punt singular. Prop d'eixe punt, la interpolació deixa de tindre valor i, degut a l'algorisme de dibuixat usat, també a la dreta d'eixe punt.

  *És molt possible què el programa no es tanque completament en polsar el botó de tancar. En eixe cas, simplement tancar la finestreta de DOS i passar d'ell.
"
	  )
    (pack txt)
    ))



(defun configurar_programa ( canvas )
  "Assigna valors a les variables del programa."
  (let*
      ((topl (make-instance 'toplevel :master nil :title "Configurar"))
       (label_ix (make-instance 'label :master topl :text "Interval x"))
       (label_iy (make-instance 'label :master topl :text "Interval y"))
       (entry_x_min (make-instance 'entry :master topl :text (coordenatedcanvas::x_min canvas )))
       (entry_y_min (make-instance 'entry :master topl :text (coordenatedcanvas::y_min canvas)))
       (entry_x_max (make-instance 'entry :master topl :text (coordenatedcanvas::x_max canvas)))
       (entry_y_max (make-instance 'entry :master topl :text (coordenatedcanvas::y_max canvas)))
       (label_ax (make-instance 'label :master topl :text "Ample divisions x"))
       (label_ay (make-instance 'label :master topl :text "Ample divisions y"))
       (entry_ax (make-instance 'entry :master topl :text (coordenatedcanvas::x_div_width canvas )))
       (entry_ay (make-instance 'entry :master topl :text (coordenatedcanvas::y_div_width canvas)))
       (label_tolerancia (make-instance 'label :master topl :text "Tolerancia a les singularitats."))
       (entry_tolerancia (make-instance 'entry :master topl :text *tolerancia* ))
       (label_sx (make-instance 'label :master topl :text "Separació dels punts camp (x)" ))
       (entry_sx (make-instance 'entry :master topl :text *separacio_camps_x*))
       (label_sy (make-instance 'label :master topl :text "Separacio dels punts camp (y)"))
       (entry_sy (make-instance 'entry :master topl :text *separacio_camps_y*))
       (boto_aplicar (make-instance 'button :master topl :text "Aplicar canvis" :command (lambda 
								      ()
											   (let
											       ((x_min (string2integer (text entry_x_min)))
												(x_max (string2integer (text entry_x_max)))
												(y_min (string2integer (text entry_y_min)))
												(y_max (string2integer (text entry_y_max)))
												(div_x (string2integer (text entry_ax)))
												(div_y (string2integer (text entry_ay)))
												(tolerancia (string2number (text entry_tolerancia)))
												(sx (string2number (text entry_sx)))
												(sy (string2number (text entry_sy))))
											     
											     (destroy topl )
											     (and x_min x_max y_min y_max div_x div_y tolerancia sx sy
												  (aplicar_canvis canvas x_min x_max y_min y_max div_x div_y tolerancia sx sy))
											     )))))
    (grid label_ix 0 0)
    (grid entry_x_min 0 1)
    (grid entry_x_max 0 2)
    (grid label_iy 1 0)
    (grid entry_y_min 1 1)
    (grid entry_y_max 1 2)
    (grid label_ax 2 0)
    (grid entry_ax 2 1)
    (grid label_ay 3 0)
    (grid entry_ay 3 1)
    (grid label_tolerancia 4 0)
    (grid entry_tolerancia 4 1)
    (grid label_sx 5 0)
    (grid entry_sx 5 1)
    (grid label_sy 6 0)
    (grid entry_sy 6 1)
    (grid boto_aplicar 7 2)
       ))


(defun dibuixa_linia (x y canvas direccio )
  "Dibuixa la linia de corrent que passa pel punt (x,y)."
  (if (or (eq *Ux* nil) (eq *Uy* nil)) 
      (progn
	(setq *Ux* nil)
	(setq *Uy* nil)
	(error "Per favor, introdueix una expressio per al camp de velocitats.")))
  (print direccio)
  (if (and (coordenatedcanvas::xbelongs2canvas x canvas) (coordenatedcanvas::ybelongs2canvas y canvas))
      (let (
	    (Ux (funcall *Ux* x y)))
	(if (> Ux 0) 
	    (progn 
	      (let ( (dx (* *multiplicador* (coordenatedcanvas::xepsilon canvas))))
		(if (eq direccio '-) (setq dx (- dx)))
				      (let*
					  (
					   (m (float (/ (funcall *Uy* x y) Ux )))
					   (x2 (float (+ x dx)))
					   (y2 (float (+ y (* m (- x2 x))))))
					(if (>= m (* *tolerancia* (- (coordenatedcanvas::y_max canvas) (coordenatedcanvas::y_min canvas) 2))) (error "Punt quasi-singular en les x. Per favor, intente calcular la línia de corrent a partir d'un punt proper.")
					    (progn
					      (itemconfigure canvas (coordenatedCanvas::drawLine canvas x y x2 y2) :fill "red")
					      (dibuixa_linia x2 y2 canvas direccio))))))
	    (progn
	      (let (
		    ( dy (* *multiplicador* (coordenatedcanvas::yepsilon canvas))))
		(if (eq direccio '-) (setq dy (- dy)))
		(let*
		    (
		     (a (float (/ Ux (funcall *Uy* x y))))
		     (y2 (float (+ y dy)))
		     (x2 (float (+ x (* a (- y2 y))))))
		  (if (>= a (* *tolerancia* (- (coordenatedcanvas::x_max canvas) (coordenatedcanvas::x_min canvas) 2))) (error "Punt quasi-singular en les y. Per favor, intente calcular la línia de corrent a partir d'un punt proper.")
		      (progn
			(itemconfigure canvas (coordenatedCanvas::drawLine canvas x y x2 y2) :fill "red")
			(dibuixa_linia x2 y2 canvas direccio))))))))))


(defun representa_velocitat_en_punt ( x y cc)
  "Dibuixa una fletxa representant la velocitat al punt x y."
  (let*
      ((x2 (+ x (funcall *Ux* x y)))
       (y2 (+ y (funcall *Uy* x y)))
       (fletxa (coordenatedCanvas::drawLine cc x y x2 y2 )))
    (itemconfigure cc fletxa  :arrow "last")
    (itemconfigure cc fletxa :fill "blue")
   
    ))

(defun representa_camp_de_velocitats ( cc )
  "Dibuixa tot el camp de velocitats."
  (unless (and *Ux* *Uy* ) (error "Per favor, introdueix una expressió per al camp de velocitats."))

  (do ((i (coordenatedCanvas::x_min cc) (incf i (* *separacio_camps_x* (coordenatedCanvas::x_div_width cc)))))
      ( (>= i (coordenatedCanvas::x_max cc))  t)
    (do ( (j (coordenatedCanvas::y_min cc) (incf j (* *separacio_camps_y* (coordenatedCanvas::y_div_width cc)))))
	((>= j (coordenatedCanvas::y_max cc)) t)
      (representa_velocitat_en_punt i j cc))))
      

(defun exportar_a_postscript ( canvas )
  "Exporta el contingut del canvas a postscript."
  (let ( nom_arxiu )
    (setq nom_arxiu (get-save-file  :filetypes '(("Arxius PostScript" ".ps")  )))
    (if nom_arxiu
	(postscript canvas nom_arxiu )
	)))



(defun aplicar_canvis ( canvas x_min x_max y_min y_max div_x div_y tolerancia sx sy)
  "Aplica canvis a la graella."
  (print 'aplicant_canvis)
  (setf (coordenatedCanvas::x_min canvas) x_min)
  (setf (coordenatedCanvas::x_max canvas) x_max)
  (setf (coordenatedCanvas::y_min canvas) y_min)
  (setf (coordenatedCanvas::y_max canvas) y_max)
  (setf (coordenatedcanvas::x_div_width canvas) div_x)
  (setf (coordenatedCanvas::y_div_width canvas) div_y)
  (coordenatedcanvas::clearScreen canvas)
  (setq *tolerancia* tolerancia)
  (setq *separacio_camps_x* sx)
  (setq *separacio_camps_y* sy)
  )




(defun llicencia ()
  "Mostra el dialeg de llicencia."
  (let*
      ((top (make-instance 'toplevel :title "Llicencia"))
       (txt (make-instance 'scrolled-text :master top )))
    (setf (text txt ) *llicencia* )
    (pack txt)
    ))





(defun main ()
  "Executa el programa."
  (setq *wish-args* '("-name" "Linies de corrent v. 003"))
  (setq *wish-pathname* "/Linies/tclkit.exe") Descomentar en windows.
  (with-ltk ( ) 
    (let*
	(
	 (finestra (make-instance 'frame :master nil ))
	 
	 (marc_superior (make-instance 'frame :master finestra :width 500 :height 600))
	 (marc_inferior (make-instance 'frame :master finestra :width 500 :height 600))
	 (canvas (make-instance 'coordenatedCanvas :master marc_inferior :width 500 :height 600 :background "white" ))
	 (entry_x (make-instance 'entry :master marc_superior :width 20))
	 (entry_y (make-instance 'entry :master marc_superior :width 20))
	 (label_titol (make-instance 'label :master marc_superior :width 30 :text "Components x-y de la velocitat."))
	 (label_x (make-instance 'label :master marc_superior :width 5 :text "Ux"))
	 (label_y (make-instance 'label :master marc_superior :width 5 :text "Uy"))
	 (boto_func (make-instance 'button :master marc_superior :width 15 :text "Usar funcions"   :command (lambda ()
													    (let
														(
														 (stx (text entry_x))
														 (sty (text entry_y)))
													      (and stx sty (asigna_funcions stx sty))))))
	 (barra_menus (make-menubar ))
	 (menu_arxiu (make-menu barra_menus "Menu arxiu"))
	 (menu_opcions (make-menu barra_menus "Menu opcions"))
	 (menu_ajuda (make-menu barra_menus "Menu ajuda"))
	 
	 )
      (coordenatedcanvas::set-function (lambda ( x y) (dibuixa_linia x y canvas '+ )
					       (dibuixa_linia x y canvas '- )) canvas)
      (make-menubutton menu_arxiu "Exportar a un grafic"   (lambda ( ) (exportar_a_postscript canvas )))
      (make-menubutton menu_arxiu "Sortir"   (lambda () (exit-wish) ))
      (make-menubutton menu_opcions "Configurar"   (lambda () (configurar_programa canvas)))
      (make-menubutton menu_ajuda "Manual"  #'manual)
      (make-menubutton menu_ajuda "Llicencia d'us"  #'llicencia )
      (make-menubutton menu_ajuda "Bugs coneguts"  #'bugs_coneguts )
      (make-menubutton menu_ajuda "A sobre de..."   #'sobre)
      (make-menubutton menu_opcions "Esborrar pantalla" (lambda ()  (coordenatedcanvas::clearscreen canvas) ))
      (make-menubutton menu_opcions "Dibuixar camp de velocitats" (lambda () (representa_camp_de_velocitats canvas)))
      (pack finestra)
      (pack marc_superior)
      (pack marc_inferior)
      (pack canvas :fill :both :expand t )
      (pack label_titol :side :left)
      (pack entry_x :side :left)
      (pack label_x :side :left)
      (pack entry_y :side :left )
      (pack label_y :side :left)
      (pack boto_func )
      
      )
    ))
