#|
Arxiu: parser.lisp
Contingut: funcions per al parsejat de formules matematiques.
Autor: Felip Alaez Nadal.
Ultima actualitzacio: 2/11/06
|#


(defpackage parser
  (:use :common-lisp ) 
  (:export #:create_function_from_expression #:x #:y) ;Ull!! No puc exportar totes les variables q use!! Cal buscar una forma millor de resoldre el conflicte de simbols.
  (:documentation "Aquest paquet proporciona una funcio, anomenada create_function_from_expression que, donat un string que conte una formula matematica, es capas
de tornar una funcio lambda en lisp que executa eixe codi. Aquesta forma de realitzar el parsejat d'una formula es particularment eficient quan la formula s'ha d'usar 
multiples vegades. Per a un sol us, el proces de compilacio pot ser prou lent. En canvi, quan s'usa varies vegades, el temps que s'empra en la compilacio es negligible, mentresque la diferencia entre l'execucio d'una funcio i el parsejat complet d'un string es molt notable. D'aquesta forma, es guanya velocitat. De totes formes la compilacio al meu pc tarda 0.0 segons normalment, la qual cosa no deuria provocar problemes filosofics a ningu. Durant la compilacio es reserven 8 Kb de memoria, que en la seua major part es alliberada una vegada es retorna la funcio llesta per a usar (els 8 kb s'usen en crear recursos auxiliars per als pasos intermitjos de la compilacio.

De moment el parser reconeixe les funcions +, -, *, /, ** (potencia), cos, sin i exp (exponencial). Per tal de que funcione correctament, cal sempre deixar un espai entre operadors i nombres, a no ser que hi haja un parentesis enmig. Per exemple, 1 +2 * 3 seria una expressio incorrecta, pero 1 +(2 * 3) no, doncs hi ha un parentesis entre + i el nombre 2."))

(in-package :parser)

(defun subllista (  llista  inferior superior )
  "Torna la subllista formada pels elements inferior, inferior + 1, ..., superior - 1, superior."
  (print llista)
(print inferior)
(print superior)
  (if (> inferior superior ) (error "L'index inferior ha de ser menor que el superior."))
  (let
      ((l (length llista))
       (retornable ())
       )
    (if (>= superior l ) (error "Index superior massa alt."))
    (if (< inferior 0) (error "No valen index negatius."))
    (if (= inferior superior ) (return-from subllista (nth inferior llista)))
    (do ((i inferior (incf i)))
	((= i (+ superior 1)) retornable)
      (setq retornable (concatenate 'list retornable (list (nth i llista))))
      )
    )
  )


(defstruct operator
  "Estructura per a guardar informacio sobre la precedencia d'un operador"
  operator
  precedence
  args)


(defun expression2list ( string )
  "Passa una expressio en un string a una llista. Retorna la llista"
  (let ( buffer llista)
    (with-input-from-string  (*standard-input*  string)
      (loop
       (setq buffer (read *standard-input* nil 'eof))
       (if (eq buffer 'eof) (return))
       (setq llista (concatenate 'list llista (list buffer)))
       )
      )
    llista
    )
  )

(defmethod parse4precedence ( ( llista cons) precedencia)
  "Processa una llista recursivament, per tal d'establir les precedencies dels operadors."
  (let ((preced (+ 10 precedencia))
	(resultat '()))
    (dolist (item llista)
      (setq resultat (concatenate 'list resultat (parse4precedence item preced)))
      )
    resultat
    )
  )

(defmethod parse4precedence ( ( nmb number) precedencia)
  "Processa un nombre per a establir la precedencia."
  (list nmb)
  )


					;De moment nomes usare com a variables x i y. En el futur es podran registrar o inclus ser expressions regulars, de forma q qualsevol cosa q concorde amb l'expressio siga considerada variable. En el futur s'ha de tornar un error si es detecta una funcio no registrada. D'aquesta forma, s'evitarien insercions de odi malicios.
(defmethod parse4precedence ( ( symbol symbol ) precedencia )
  "Processa un simbol per a establir la precedencia. Reconeix les variables i no les toca."
  (let ( retornable
	(op (make-operator :operator symbol )))
    (print 'parsejant)
    (print symbol)
    ;A continuacio registre tots els operadors que usare
    (cond 
      ((eq symbol '+)  ;Suma
       (setf (operator-precedence op) (+ precedencia 1))
       (setf (operator-args op) 2)
       (setq retornable (list op))
       )
      ((eq symbol '-)  ;Resta
       (setf (operator-precedence op) (+ precedencia 1))
       (setf (operator-args op) 2)
       (setq retornable (list op)))
      ((eq symbol '*)  ;Multiplicacio
       (setf (operator-precedence op) (+ precedencia 2))
       (setf (operator-args op) 2)
       (setq retornable (list op)))
      ((eq symbol '/)  ;Divisio
       (setf (operator-precedence op) (+ precedencia 2))
       (setf (operator-args op) 2)
       (setf retornable (list op)))
      ((eq symbol '**) ;Potencia
       (setf (operator-precedence op) (+ precedencia 3))
       (setf (operator-args op) 2)
       (setf (operator-operator op) 'expt)
       (setf retornable (list op)))
      ((eq symbol 'cos) ;Cosinus
       (setf (operator-precedence op) (+ precedencia 4))
       (setf (operator-args op) 1)
       (setf (operator-operator op) 'cos)
       (setf retornable (list op))) 
      ((eq symbol 'sin) ;Sinus
       (setf (operator-precedence op) (+ precedencia 4))
       (setf (operator-args op) 1)
       (setf (operator-operator op) 'sin)
       (setf retornable (list op)))
      ((eq symbol 'exp) ;Exponencial 
       (setf (operator-precedence op) (+ precedencia 4))
       (setf (operator-args op) 1)
       (setf (operator-operator op) 'exp)
       (setf retornable (list op)))
      ((eq symbol 'tan) ;Tangent
       (setf (operator-precedence op) (+ precedencia 4))
       (setf (operator-args op) 1)
       (setf (operator-operator op) 'tan)
       (setf retornable (list op)))
      ((eq symbol 'sinh) ;Sinus hiperbòlic
       (setf (operator-precedence op) (+ precedencia 4))
       (setf (operator-args op) 1)
       (setf (operator-operator op) 'sinh)
       (setf retornable (list op)))
       ((eq symbol 'cosh) ;cosinus hiperbòlic
	(setf (operator-precedence op) (+ precedencia 4))
	(setf (operator-args op) 1)
	(setf (operator-operator op) 'cosh)
	(setf retornable (list op)))
       ((eq symbol 'tanh) ;Tangent hiperbòlica
	(setf (operator-precedence op) (+ precedencia 4))
	(setf (operator-args op) 1)
	(setf (operator-operator op) 'tanh)
	(setf retornable (list op)))
      ;Aci registre les variables. De moment, simplement torne el simbol.
      ((eq symbol 'X ) ;Variable x
       (print 'variable)
       (setq retornable (list 'x)))
      ((eq symbol 'y)  ;Variable y
       (print 'variable)
       (setq retornable (list 'y)))
      ( t
       (format t "El puto simbol és ~A~%" symbol))
      )
    (print 'retornable=)
    (print retornable)
    retornable
    )
  )


(defmethod parse4function ( ( llista cons) )
  "Parseja una llista de precedencies i torna una funcio."
  (let 
      ((l (length llista))
       (min 999)
       (pos_min 0)
       subllista_1
       subllista_2
       element
       arg_1
       arg_2
       operador
       n_args
       retornable
       )
    (print 'function)
    (print llista)
    (if
     (= l 1) ;Si la llista te longitut 1, pot ser una constant o un error.
     (setq retornable (parse4function (first llista)))
     (progn ;En altre cas, usem un algorisme 
					;Primer busque l'operador de minima precedencia
       (do ((i 0 (incf i)))
	   ((= i l) t)
	 (setq element (nth i llista))
	 (when (eq (type-of element) 'operator)
	   (let
	       ((precedencia (operator-precedence element)))
	     (if (< precedencia min) (progn 
				       (setq min precedencia)
				       (setq pos_min i))
		 )
	     )
	   )
	 )
					;Identifique l'operador 
       (setq operador (nth pos_min llista))
					;Esbrine quants arguments necessite
       (setq n_args (operator-args operador))
					;Si necessita dos arguments, he de processar el q te a l'esquerra i el q te a la dreta
       (when (= n_args 2)
	 (setq subllista_1 (subllista llista 0 (- pos_min  1)))
	 (setq subllista_2 (subllista llista (+ pos_min  1) (- l 1)))
	 (setq arg_1 (parse4function subllista_1 ))
	 (setq arg_2 (parse4function subllista_2 ))
      (setq retornable `( ,(operator-operator operador ) ,arg_1 ,arg_2 ))
      )
					;Si nomes necessita un argument, nomes em cal processar el q hi ha a la dreta de l'operador
       (when (= n_args 1)
	 (setq subllista_1 (subllista llista (+ pos_min 1) (- l  1)))
	 (setq arg_1 (parse4function subllista_1 ))
	 (setq retornable `( ,(operator-operator operador ) ,arg_1  ))  
	 
	 )
       retornable
       )
     )
    )
  )
    (defmethod parse4function ( ( nmb number ))
  "Parseja un nombre per tal de poder tornar una funcio."
  ;Simplement torna el nombre
  nmb
  )

(defmethod parse4function (( smb symbol ))
  "Parseja una variable per tal de poder tornar una funcio."
  ;Simplement torna la variable
  smb
  )

(defun create_function_from_expression ( string )
  "Torna una funcio capas d'evaluar l'expressio continguda a una cadena de text. Aquesta aproximacio es particularment eficient quan s'ha d'evaluar moltes vegades la funcio. El proces de compilacio de la funcio, en canvi, provoca excesiva lentitut per a una unica avaluacio."
  (let ( exp tmp )
					;Obte una llista de simbols
    (setq exp (expression2list string ))
					;Obte una llista amb els operadors classificats segons la precedencia
    (setq exp (parse4precedence exp 0))
					;Obte el cos d'una funcio lisp que executa l'expressio
    (setq exp (parse4function exp ))
					;Retorna una funcio lambda capas d'executar eixe cos
    (setq tmp `(lambda ( x y ) ,exp ))
    (values (eval tmp) tmp)
    )
  )